#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int N, K;
    cin >> N >> K;

    vector<int> lokacijeProdavnica(K);
    vector<bool> imaProdavnicu(N + 1, false);

    for (int i = 0; i < K; ++i) {
        cin >> lokacijeProdavnica[i];
        imaProdavnicu[lokacijeProdavnica[i]] = true;
    }

    vector<long long int> populacija(N);
    for (long long int i = 0; i < N; ++i) {
        cin >> populacija[i];
    }

    long long int ukupnaPopulacija = 0;
    for (long long int i = 0; i < N; ++i) {
        ukupnaPopulacija += populacija[i];
    }

    long long int kupciUProdavnicama = 0;
    for (int lokacija : lokacijeProdavnica) {
        kupciUProdavnicama += populacija[lokacija - 1];
    }

    long long int preostalaPopulacija = ukupnaPopulacija - kupciUProdavnicama;
    if (preostalaPopulacija < (ukupnaPopulacija / 2)) {
        cout << "-1" << endl;
        return 0;
    }
    if(kupciUProdavnicama == 0 && preostalaPopulacija>0){
        cout << "1";
        return 0;
    }

    int preostaliGradovi = 0;
    for (int i = 1; i <= N; ++i) {
        if (!imaProdavnicu[i]) {
            ++preostaliGradovi;
        }
    }

    int potrebnoProdavnica = 0;
    long long int kupci = 0;
    while (preostaliGradovi > 0) {
        int gradSaNajviseStanovnika = 0;
        long long int najviseStanovnika = 0;
        for (int i = 0; i < N; ++i) {
            if (!imaProdavnicu[i + 1] && populacija[i] > najviseStanovnika) {
                najviseStanovnika = populacija[i];
                gradSaNajviseStanovnika = i + 1;
            }
        }
        kupci += najviseStanovnika;
        if (kupci > (ukupnaPopulacija / 2)) {
            cout << potrebnoProdavnica + 1 << endl; 
            return 0;
        }
        imaProdavnicu[gradSaNajviseStanovnika] = true;
        --preostaliGradovi;
        ++potrebnoProdavnica;
    }

    cout << potrebnoProdavnica << endl;

    return 0;
}